
//Experiment - 8
//Application of sound effect on wave file like Flanging, Echo and Equalizer.


// The "dsp01.wav" file should be placed in current working directory
// The code can also be executed with any other small .wav file of duration 3-5 seconds. 
clc;
clear;
clear all;

[y,fs] = wavread('dsp01.wav');
playsnd(y,fs);

halt('Original');

//Flanging
z = 0;
n = 1:length(y);
z(n) = y(n);
m = 11:length(y);
x(m) = z(m) + 0.8*z(m-10).*cos(2*%pi*m/fs);
playsnd(x,fs);
halt('Flange');


//Echo
clc;
clear all;
a = 0.5;
[l,fs] = wavread('dsp01.wav');
len = length(l);
delay = 0.4;
D = ceil(fs*delay);
m = zeros(max(size(l)));
for i = D+1:len
  m(i) = l(i) + a*l(i-D);
end

playsnd(m,fs);


halt('Echo');

//Equalizer
//For Low frequencies
clc;
clear all;

[h,fs] = wavread('dsp01.wav');
playsnd(h,fs);
halt('Original');

j = iir(3,'bp','butt',[.01 .05],[0.03 0.03]);

k = flts(h(1,:),j);
playsnd(k,fs);
halt('Low');

// For Mid frequencies
clc;
clear all;

[g,fs] = wavread('dsp01.wav');
playsnd(g,fs);
halt('Original');

j = iir(3,'bp','ellip',[.05 .10],[.08 .03]);

k = flts(g(2,:),j);
sound(k,fs);

halt('Mid');

//For High frequencies
clc;
clear all;

[h,fs] = wavread('dsp01.wav');
playsnd(h,fs);
halt('Original');

j = iir(3,'bp','butt',[.15 .25],[0.03 0.03]);

k = flts(h(1,:),j);
playsnd(k,fs);

halt('High');
